/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_wait_any.c,v 1.8 2006/03/24 20:49:36 bgoglin Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__request.h"
#include "mx__error.h"
#include "mx__sleep.h"
#include "mx__endpoint.h"

int
mx__test_common(mx_endpoint_t endpoint, mx_request_t *request,
		mx_status_t *status);
int
mx__ipeek_common(mx_endpoint_t endpoint, uint64_t match_info, uint64_t match_mask,
		 mx_request_t *request);
mx_return_t
mx__peek_common(mx_endpoint_t endpoint, uint64_t match_info, uint64_t match_mask,
		uint32_t timeout, int is_wait_any,
		mx_request_t *request, uint32_t *result);

MX_FUNC(mx_return_t)
mx_wait_any(mx_endpoint_t endpoint, uint32_t timeout,
	    uint64_t match_info, uint64_t match_mask,
	    mx_status_t *status, uint32_t *result)
{
  mx_request_t any;
  mx_return_t ret;

  if (match_info & ~match_mask) {
    return mx__error(endpoint, "mx_test_any", MX_BAD_MATCH_MASK);
  }

  /* check that there's no wildcard in the context id range */
  if (!CHECK_MATCHING_WITH_CTXID(endpoint, match_mask)) {
    return mx__error(endpoint, "mx_test_any", MX_BAD_MATCHING_FOR_CONTEXT_ID_MASK);
  }

  MX__MUTEX_LOCK(&endpoint->lock);
  mx__luigi(endpoint);
  ret = mx__peek_common(endpoint, match_info, match_mask, timeout, 1, &any, result);
  if (ret != MX_SUCCESS) {
    /* peek failed */
    MX__MUTEX_UNLOCK(&endpoint->lock);
    return ret;
  }
  if (*result) {
    /* test the request */
    int test_result = mx__test_common(endpoint, &any, status);
    mx_always_assert(test_result);
  }

  MX__MUTEX_UNLOCK(&endpoint->lock);
  return MX_SUCCESS;
}

MX_FUNC(mx_return_t)
mx_test_any(mx_endpoint_t endpoint, uint64_t match_info, uint64_t match_mask,
	    mx_status_t *status, uint32_t *result)
{
  mx_request_t any;

  if (match_info & ~match_mask) {
    return mx__error(endpoint, "mx_test_any", MX_BAD_MATCH_MASK);
  }

  /* check that there's no wildcard in the context id range */
  if (CTXID_FROM_MATCHING(endpoint, match_mask)) {
    return mx__error(endpoint, "mx_test_any", MX_BAD_MATCHING_FOR_CONTEXT_ID_MASK);
  }

  MX__MUTEX_LOCK(&endpoint->lock);
  MX__EP_STATS_INC(endpoint, test);
  mx__luigi(endpoint);
  *result = mx__ipeek_common(endpoint, match_info, match_mask, &any);
  if (*result) {
    /* test the request */
    int test_result = mx__test_common(endpoint, &any, status);
    mx_always_assert(test_result);
  } else {
    MX__EP_STATS_INC(endpoint, noncompleted_test);
  }

  MX__MUTEX_UNLOCK(&endpoint->lock);
  return MX_SUCCESS;
}
